# include <osbind.h>

# define GET				-1
# define SET_THE_REG		0x60
# define MIXERREG			07

/*
** Read or set the noise enable bit in the mixer register
** Just like tone enable, but the noise bits are three bits to the left
** of the tone bits.
** Note that turning a bit in the mixer ON turns the feature OFF.
*/

noise_enable(channel,on_off)
int channel, on_ff; {
	
		int old_val;
		
		if( on_off == GET )
			return( !((Giaccess(0,MIXERREG) >> (channel+3)) & 1));
		old_val = Giaccess(0,MIXERREG);
		if( on_off )
		old_val &= ~(1 << (channel+3));					/* turn the bit OFF */
			else
		old_val |= 1 << (channel+3);					/* turn the bit ON */
		Giaccess( old val, MIXERREG + SET_THE_REG );
}